/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskNumericProperty;
import filenet.vw.apps.taskman.pa.PANode;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardControl;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardPanel;
import filenet.vw.apps.taskman.toolkit.dialog.VWTaskWizardDialog;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Level;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class PAPruneRegionDialog
extends VWTaskWizardDialog {
    PANode m_node = null;
    RegionInputPanel m_regionInputPanel = null;
    ConfirmationPanel m_confirmPanel = null;

    public PAPruneRegionDialog(PANode node) {
        super((Frame)VWTaskCore.getInstance().getMainFrame(), VWResource.PruneIsolatedRegion, VWStringUtils.stringToDimension(VWResource.PruneRegionDialogDim));
        super.setConfirmOnCancel(false);
        this.m_node = node;
        this.setButtonText(2, VWResource.Prune);
        this.m_regionInputPanel = new RegionInputPanel();
        this.addWizardPanel(this.m_regionInputPanel);
        ConfirmationPanel m_confirmPanel = new ConfirmationPanel();
        this.addWizardPanel(m_confirmPanel);
    }

    public void finish() throws Exception {
        this.m_node.getPAAdministration().pruneIsolatedRegion(this.m_regionInputPanel.getRegion());
        this.m_node.writeMessage(Level.INFO, new VWString("filenet.vw.apps.taskman.pa.PAPruneRegionDialog.PruneRegionInitiated", "Prune isolated region initiated for region {0}.").toString(new Integer(this.m_regionInputPanel.getRegion())));
    }

    public class ConfirmationPanel
    extends JPanel
    implements IVWTaskWizardPanel {
        JTextField m_region = null;

        public ConfirmationPanel() {
            this.initLayout();
        }

        public void performValidation() throws Exception {
        }

        public String getInstructions() {
            return null;
        }

        public String getHelpPath() {
            return VWHelp.Help_Process_TaskManager + "pa.htm";
        }

        public void refresh() {
            this.m_region.setText("" + PAPruneRegionDialog.this.m_regionInputPanel.getRegion());
        }

        private void initLayout() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 23;
            c.fill = 2;
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(10, 5, 0, 5);
            this.add((Component)this.getMessagePanel(), c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(30, 5, 0, 5);
            this.add((Component)this.getRegionPanel(), c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(0, 0, 0, 0);
            c.fill = 1;
            this.add(Box.createHorizontalStrut(0), c);
        }

        private JPanel getMessagePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 23;
            c.fill = 2;
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 0, 0, 0);
            JLabel warningIcon = new JLabel(UIManager.getIcon("OptionPane.warningIcon"), 2);
            panel.add((Component)warningIcon, c);
            c.gridx = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 10, 0, 0);
            JTextArea message = new JTextArea(2, 2);
            message.setEditable(false);
            message.setBackground(this.getBackground());
            message.setLineWrap(true);
            message.setWrapStyleWord(true);
            message.setFont(new JLabel().getFont());
            message.setText(VWResource.PruneIsolatedRegionConfirmMsg);
            panel.add((Component)message, c);
            return panel;
        }

        private JPanel getRegionPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 23;
            c.fill = 2;
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 42, 0, 0);
            panel.add((Component)new JLabel(VWResource.IsolatedRegion + ":"), c);
            c.gridx = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 10, 0, 0);
            this.m_region = new JTextField();
            this.m_region.setEditable(false);
            this.m_region.setColumns(5);
            this.m_region.setFont(new JLabel().getFont());
            this.m_region.setBorder(null);
            panel.add((Component)this.m_region, c);
            c.gridx = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 0, 0, 0);
            panel.add(Box.createHorizontalStrut(1), c);
            return panel;
        }

        public boolean skipThisPanel() {
            return false;
        }
    }

    public class RegionInputPanel
    extends JPanel
    implements IVWTaskWizardPanel,
    IVWTaskWizardControl,
    KeyListener {
        public JTextField m_region = null;

        public RegionInputPanel() {
            this.initLayout();
        }

        public int getRegion() throws NumberFormatException {
            return Integer.parseInt(this.m_region.getText().trim());
        }

        public void performValidation() throws Exception {
        }

        public String getInstructions() {
            return null;
        }

        public String getHelpPath() {
            return VWHelp.Help_Process_TaskManager + "pa_actions_prune_region.htm";
        }

        public void refresh() {
        }

        public boolean allowButtonToBeEnabled(int button) {
            if (button == 1) {
                return this.m_region.getText().trim().length() > 0;
            }
            return true;
        }

        public void keyReleased(KeyEvent evt) {
            PAPruneRegionDialog.this.updateButtonState();
        }

        public void keyPressed(KeyEvent evt) {
        }

        public void keyTyped(KeyEvent evt) {
        }

        private void initLayout() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 23;
            c.fill = 2;
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 10, 0, 0);
            this.add((Component)new JLabel(VWResource.IsolatedRegion + ":"), c);
            c.gridx = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 10, 0, 0);
            this.m_region = new VWTaskNumericProperty("");
            this.m_region.setColumns(5);
            this.m_region.addKeyListener(this);
            this.add((Component)this.m_region, c);
            c.gridx = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 0, 0, 0);
            this.add(Box.createHorizontalStrut(0), c);
        }

        public boolean skipThisPanel() {
            return false;
        }
    }
}

